;----------------------------------------------------------------------------
;    MODULE NAME:   TryMeShortcuts.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.4  $
;          $Date:   04 Jun 2007 17:40:56  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeShortcuts.MM.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; Demonstrates shortcut creation.
;
; Note that the standard Windows Installer "ProgramMenuFolder" system folder
; property points to the "all users" location for per-machine installs else
; into the users "Start->Programs" location.
;
; An "advertised" shortcut is one which will invoke a repair or installation
; on demand if required before invoking the program.  There is no way of
; specifying the program being invoked (stupid as you can specify the arguments)
; so the associated program will be launched.  Users have limited shortcut
; editing ability and the shortcuts will stop working when a new version of
; the product is installed (only an issue if the user makes their own copy).
;
; A non-advertised shortcut is the traditional shortcut that has always been
; around.
;
; The default for MAKEMSI is a per machine install (ALLUSERS=1) so the
; shortcuts are created for "all users".  The standard Microsoft validation
; suite does not understand the context and for this reason will create
; 2 warning messages if the "NonAdvertisedShortcut" component is created
; with file keypath or LM=Y (rather than CU=Y which it wants).
; However if you do use CU=Y then an unnecessary repair will take place for
; each user to create the per-user component keypath.  This is one case where
; it is wise to ignore a validation message (be sure you understand them first
; though).
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;--- Override some MAKEMSI options ------------------------------------------
;----------------------------------------------------------------------------
#define  VER_FILENAME.VER  TryMe.Ver  ;;I only want one VER file for all samples!


;----------------------------------------------------------------------------
;--- Include MAKEMSI support (with my customisations and MSI branding) ------
;----------------------------------------------------------------------------
#include "ME.MMH"


;----------------------------------------------------------------------------
;--- Create INSTALLDIR ------------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="INSTALLDIR" Dir="c:\program files\TryMe (makemsi sample)\<$MAKEMSI_MM_BASENAME>" CHANGE="\" PrimaryFolder="Y">


;----------------------------------------------------------------------------
;--- Create Advertised shortcut to "open" "TryMeShortcuts.MM" ---------------
;----------------------------------------------------------------------------
<$Component "AdvertisedShortcut" Create="Y" Directory_="INSTALLDIR">
    ;--- Add the files to the "TryMe" component -----------------------------
    <$File SOURCE="TryMeShortcuts.MM" KeyPath="Y">

    ;--- Add the shortcut (advertise the "complete" feature) ----------------
    #(
        ;--- Advertised shortcut in "Start->programs" -----------------------
        <$Shortcut
                   Dir="ProgramMenuFolder"          ;;Add to "Start->Programs
               Feature="."
                 Title="Opens TryMeShortcuts.MM (via default association)"
           Description=^This advertised shortcut simply opens "TryMeShortcuts.MM" in associated handler (probably notepad)!^
                  Icon="@.\TryMe.ico"
               WorkDir="INSTALLDIR"
        >
    #)
<$/Component>


;-------------------------------------------------------------------------------------------
;--- Create non-advertised shortcut (in Start->Programs->TryMeShortcuts (non-advertised) ---
;-------------------------------------------------------------------------------------------
<$Component "NonAdvertisedShortcut" Create="Y" Directory_="INSTALLDIR">
    ;--- Create directory (add to "RemoveFile" table to keep validations happy) ---
    <$DirectoryTree Key="MY_SHORTCUT_FOLDER" Dir="[ProgramMenuFolder]\TryMeShortcuts (non-advertised)" MAKE="Y" REMOVE=Y">

    ;--- Install "TryMe.VER" ------------------------------------------------
    <$File SOURCE="TryMe.VER" KeyPath="Y" RowKey="TryMe.VER">

    ;--- Create shortcut which invokes "notepad" to view the file -----------
    #(
        <$Shortcut
                   Dir="MY_SHORTCUT_FOLDER"
                Target="[SystemFolder]notepad.exe"
                 Title="Open TryMeShortcuts .VER File"
           Description=^This non-advertised shortcut simply opens "TryMe.VER" in notepad!^
;            Arguments=^"[INSTALLDIR]TryMeShortcuts.MM"^  ;;Not so good (as not self validating - mistake only picked up by testing shortcut)
             Arguments=^"[!TryMe.VER]"^                   ;;Better as will self validate, build fails if you forget to add file!
                  Icon="@.\TryMe.ico"
               WorkDir="INSTALLDIR"
        >
    #)

    ;--- As mentioned above we can ignore validation warnings as install is per-machine ---
    <$MsiValFilter "Component NonAdvertisedShortcut has non-advertised shortcuts. It should use a registry key under HKCU as its KeyPath"  Comment=^Not true, this MSI installs per-machine^>
    <$MsiValFilter "Component 'NonAdvertisedShortcut' has both per-user and per-machine data with a per-machine KeyPath."                  Comment=^Not true, this MSI installs per-machine^>
<$/Component>


;--------------------------------------------------------------------------------------
;--- Define Reusable macro (best defined in "common header") for uninstall shortcut ---
;--------------------------------------------------------------------------------------
;--[4Doco-Define.UninstallShortcut]---
#(
    ;--- Note that MS don't like, they want you to go via Add-Remove Applet ---
    #define UninstallShortcut               ;;Version 07.119

    ;--- Make PER-MACHINE (practical) or PER-USER (keep MS happy) component? ---
    #if ['{$LOGO=^N^ $$UPPER}' = 'Y']
        ;--- Create PER-USER component (For LOGO, keep Microsoft happy) -----
        #define+ @@CU  Y
        #define+ @@LM  N
    #elseif
        ;--- Create PER-MACHINE component (less annoying for multiple users) ---
        #define+ @@CU  N
        #define+ @@LM  Y
    #endif

    ;--- Direct Uninstall or Maintenance Dialog (preferred & default)? ------
    #if ['{$Maint=^Y^ $$UPPER}' = 'N']
        ;--- Direct Uninstall (no repair options etc) -----------------------
        #define+ @@What       Uninstall
        #define+ @@WhatSwitch /x
    #elseif
        ;--- The Default, use maintenance dialog (can choose remove) --------
        #define+ @@What       Maintain
        #define+ @@WhatSwitch /i
    #endif

    ;--- Define the component -----------------------------------------------
    <$Component "UninstallShortcut" Create="Y" Directory_="<$AnyDir>" LM="<$@@LM>"  CU="<$@@CU>">
        ;--- Create shortcut (unfortunately ICE lac of smarts will interpret as PER-USER) ---
        #(
            <$Shortcut
                       Dir="[{$SCDIR}]"
                     Title=^{$Title=~<$@@What> <$ProdInfo.ProductName>~}^
                      Icon="{$Icon=^.\<$@@What>Shortcut.ico^}"
                    Target="[System64Folder]msiexec.exe"                   ;;Windows Installer EXE
                 Arguments=^<$@@WhatSwitch> [ProductCode] {$Args=''}^      ;;Maint/Uninstall switch and product code (plus possible extra user parms)
               Description=^{$ToolTip=~<$@@What>s <$ProdInfo.ProductName> version <$ProductVersion>~}^
            >
        #)

        ;--- No need to ignore ICE messages if creating as per LOGO requirements ---
        #if ['{$LOGO $$UPPER}' <> 'Y']
            ;--- Installed PER-MACHINE, Stop the whinging... ----------------
            <$MsiValFilter "Component UninstallShortcut has non-advertised shortcuts. It's KeyPath registry key should fall under HKCU"  Comment=^Not true, this MSI installs per-machine^>
            <$MsiValFilter "Component 'UninstallShortcut' has both per-user and per-machine data with a per-machine KeyPath"             Comment=^Not true, this MSI installs per-machine^>
        #endif
    <$/Component>
#)
;--[4Doco-Define.UninstallShortcut]---


;--- Add the UNINSTALL shortcut ---------------------------------------------
;--[4Doco-Use.UninstallShortcut]---
<$UninstallShortcut SCDIR="MY_SHORTCUT_FOLDER" Icon="@.\TryMe.ico">
;<$UninstallShortcut SCDIR="MY_SHORTCUT_FOLDER" Icon="@.\TryMe.ico" Maint='N' Args="/qb">  ;;Direct Uninstall, Don't confirm (NOT recommended)
;--[4Doco-Use.UninstallShortcut]---